/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.ProvSSLSessionContext;
import kl.ssl.jsse.provider.SSLSessionUtil;
import kl.ssl.jsse.provider.SessionBindingListenerAdapter;
import org.bouncycastle.util.Arrays;

abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;
    protected long lastAccessedTime;
    protected boolean invalidated;

    ProvSSLSessionBase(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort) {
        this.sslSessionContext = sslSessionContext;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.creationTime = System.currentTimeMillis();
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
        this.lastAccessedTime = this.creationTime;
        this.invalidated = false;
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract kl.ssl.gmvpn.Certificate getLocalCertificateTLS();

    protected abstract kl.ssl.gmvpn.Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    synchronized void accessedAt(long accessTime) {
        this.lastAccessedTime = Math.max(this.lastAccessedTime, accessTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase other = (ProvSSLSessionBase)obj;
        return Arrays.areEqual((byte[])this.getIDArray(), (byte[])other.getIDArray());
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return this.sslSessionContext.getSSLContext().getCipherSuiteString(this.getCipherSuiteTLS());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        byte[] id = this.getIDArray();
        return null == id ? TlsUtils.EMPTY_BYTES : Arrays.clone((byte[])id);
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.getLocalCertificateTLS());
        if (null != chain && chain.length > 0) {
            return chain;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        return JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.getLocalCertificateTLS());
    }

    @Override
    public int getPacketBufferSize() {
        return 18443;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        Certificate[] peerCertificates = this.getPeerCertificates();
        try {
            X509Certificate[] chain = new X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                chain[i] = X509Certificate.getInstance(peerCertificates[i].getEncoded());
            }
            return chain;
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.getPeerCertificateTLS());
        if (null != chain && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.getPeerCertificateTLS());
        if (null != principal) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public String getProtocol() {
        return this.sslSessionContext.getSSLContext().getProtocolString(this.getProtocolTLS());
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    @Override
    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getIDArray());
    }

    @Override
    public void invalidate() {
        this.sslSessionContext.removeSession(this.getIDArray());
        this.invalidated = true;
    }

    @Override
    public boolean isValid() {
        byte[] sessionID = this.getIDArray();
        return null != sessionID && sessionID.length > 0 && !this.invalidated;
    }

    @Override
    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }
}

