/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import kl.ssl.gmvpn.DefaultTlsKeyExchangeFactory;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsKeyExchangeFactory;
import kl.ssl.gmvpn.TlsPeer;
import kl.ssl.gmvpn.crypto.TlsCrypto;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
    }

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    @Override
    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedPadding() {
        return false;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }

    @Override
    public int getRenegotiationPolicy() {
        return 0;
    }
}

