/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.KmsApi;
import com.ghca.kms.thrift.api.KmsException;
import com.koal.kms.sdk.ed.AbstractKmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsClientConfigInitializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.THttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsClientHttpImpl
extends AbstractKmsClient {
    private static final Logger logger = LoggerFactory.getLogger(KmsClientHttpImpl.class);
    private final String protocol_http = "http";
    private final String protocol_https = "https";
    private final KmsApi.Client kmsApiClient;
    private final KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();
    private THttpClient tHttpClient;

    KmsClientHttpImpl() throws KmsException {
        String address = this.kmsClientConfig.getAddress();
        String contextPath = this.kmsClientConfig.getContextPath();
        try {
            this.tHttpClient = this.kmsClientConfig.useTLS() ? new THttpClient("https://" + address + contextPath, (HttpClient)this.buildHttpClient()) : new THttpClient("http://" + address, (HttpClient)this.buildHttpClient());
        }
        catch (Exception e) {
            logger.error("new THttpClient error", (Throwable)e);
            throw new KmsException(e.getMessage());
        }
        this.tHttpClient.setCustomHeader("kid", this.kmsClientConfig.getKcspKid());
        this.kmsApiClient = new KmsApi.Client(new TBinaryProtocol(this.tHttpClient));
        this.tHttpClient.open();
    }

    @Override
    protected KmsApi.Client getKmsApiClient() {
        return this.kmsApiClient;
    }

    @Override
    public KmsApi.Client getApiClient() throws KmsException {
        return this.kmsApiClient;
    }

    @Override
    protected void returnKmsApiClient(KmsApi.Client client) {
        try {
            this.closeKmsClient(client);
        }
        catch (KmsException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeKmsClient(KmsApi.Client client) throws KmsException {
        if (client != null) {
            this.tHttpClient.close();
        }
    }

    private CloseableHttpClient buildHttpClient() throws Exception {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingHttpClientConnectionManager()).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultClientConnectionReuseStrategy()).setConnectionManagerShared(true).build();
    }

    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager() throws Exception {
        byte[] trustStoreByte;
        String trustStorePath = this.kmsClientConfig.getTrustStorePath();
        String keyStorePath = this.kmsClientConfig.getKeyStorePath();
        char[] trustStorePassword = this.toNullableCharArray(this.kmsClientConfig.getTrustStorePassword());
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        sslContextBuilder = KmsClientConfigInitializer.isInitialized() ? (null != (trustStoreByte = this.kmsClientConfig.getInitializer().getTrustStore()) && trustStoreByte.length != 0 ? this.loadTrustMaterial(new ByteArrayInputStream(trustStoreByte), sslContextBuilder, trustStorePassword, null) : sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy())) : (null != trustStorePath && !"".equals(trustStorePath) ? sslContextBuilder.loadTrustMaterial(new File(trustStorePath), trustStorePassword) : sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()));
        char[] keyStorePassword = this.toNullableCharArray(this.kmsClientConfig.getKeyStorePassword());
        char[] keyPassword = this.toNullableCharArray(this.kmsClientConfig.getKeyPassword());
        if (KmsClientConfigInitializer.isInitialized()) {
            byte[] keyStoreByte = this.kmsClientConfig.getInitializer().getKeyStore();
            if (null != keyStoreByte && keyStoreByte.length != 0) {
                sslContextBuilder = this.loadKeyMaterial(new ByteArrayInputStream(keyStoreByte), sslContextBuilder, keyStorePassword, keyPassword, null);
            }
        } else if (null != keyStorePath && !"".equals(keyStorePath)) {
            sslContextBuilder = sslContextBuilder.loadKeyMaterial(new File(keyStorePath), keyStorePassword, keyPassword);
        }
        SSLContext sslContext = sslContextBuilder.build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry build = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(build);
        poolingHttpClientConnectionManager.setMaxTotal(this.kmsClientConfig.getPooling().getMaxTotal());
        poolingHttpClientConnectionManager.setValidateAfterInactivity(this.kmsClientConfig.getPooling().getValidatePeriod());
        return poolingHttpClientConnectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(ByteArrayInputStream byteArrayInputStream, SSLContextBuilder sslContextBuilder, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            identityStore.load(byteArrayInputStream, storePassword);
        }
        finally {
            byteArrayInputStream.close();
        }
        return sslContextBuilder.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(ByteArrayInputStream byteArrayInputStream, SSLContextBuilder sslContextBuilder, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            trustStore.load(byteArrayInputStream, storePassword);
        }
        finally {
            byteArrayInputStream.close();
        }
        return sslContextBuilder.loadTrustMaterial(trustStore, trustStrategy);
    }

    private char[] toNullableCharArray(String string) {
        if (null != string) {
            return string.toCharArray();
        }
        return null;
    }
}

