/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import com.ghca.kms.thrift.api.Algorithm;
import com.ghca.kms.thrift.api.AsymmetricDecryptRequest;
import com.ghca.kms.thrift.api.AsymmetricDecryptResponse;
import com.ghca.kms.thrift.api.AsymmetricEncryptRequest;
import com.ghca.kms.thrift.api.AsymmetricEncryptResponse;
import com.ghca.kms.thrift.api.AsymmetricSignRequest;
import com.ghca.kms.thrift.api.AsymmetricVerifyRequest;
import com.ghca.kms.thrift.api.ChallengeRequest;
import com.ghca.kms.thrift.api.ChallengeResponse;
import com.ghca.kms.thrift.api.ChallengeTokenRequest;
import com.ghca.kms.thrift.api.ChallengeTokenResponse;
import com.ghca.kms.thrift.api.CreateKeyRequest;
import com.ghca.kms.thrift.api.CreateKeyResponse;
import com.ghca.kms.thrift.api.DecryptByDataKeyRequest;
import com.ghca.kms.thrift.api.DecryptRequest;
import com.ghca.kms.thrift.api.DecryptResponse;
import com.ghca.kms.thrift.api.DeleteKeyRequest;
import com.ghca.kms.thrift.api.DeriveAlgorithm;
import com.ghca.kms.thrift.api.DeriveKeyRequest;
import com.ghca.kms.thrift.api.DeriveKeyResponse;
import com.ghca.kms.thrift.api.DescribeKeyRequest;
import com.ghca.kms.thrift.api.DescribeKeyResponse;
import com.ghca.kms.thrift.api.DigestAlgorithm;
import com.ghca.kms.thrift.api.DigestType;
import com.ghca.kms.thrift.api.EncryptByDataKeyRequest;
import com.ghca.kms.thrift.api.EncryptRequest;
import com.ghca.kms.thrift.api.EncryptResponse;
import com.ghca.kms.thrift.api.ExportSymmetricKeyRequest;
import com.ghca.kms.thrift.api.ExportSymmetricKeyResponse;
import com.ghca.kms.thrift.api.GenerateDataKeyRequest;
import com.ghca.kms.thrift.api.GenerateDataKeyResponse;
import com.ghca.kms.thrift.api.GenerateKeyPairRequest;
import com.ghca.kms.thrift.api.GenerateKeyPairResponse;
import com.ghca.kms.thrift.api.GenerateRandomRequest;
import com.ghca.kms.thrift.api.GenerateRandomResponse;
import com.ghca.kms.thrift.api.GetDataKeyRequest;
import com.ghca.kms.thrift.api.GetDataKeyResponse;
import com.ghca.kms.thrift.api.GetPublicKeyRequest;
import com.ghca.kms.thrift.api.GetPublicKeyResponse;
import com.ghca.kms.thrift.api.HmacRequest;
import com.ghca.kms.thrift.api.HmacResponse;
import com.ghca.kms.thrift.api.HmacVerifyRequest;
import com.ghca.kms.thrift.api.HmacVerifyResponse;
import com.ghca.kms.thrift.api.KeySpec;
import com.ghca.kms.thrift.api.KeyUsage;
import com.ghca.kms.thrift.api.KmsApi;
import com.ghca.kms.thrift.api.Mode;
import com.ghca.kms.thrift.api.Origin;
import com.ghca.kms.thrift.api.PingRequest;
import com.ghca.kms.thrift.api.ProtectionLevel;
import com.ghca.kms.thrift.api.SignWithHashedRequest;
import com.ghca.kms.thrift.api.TokenRequest;
import com.ghca.kms.thrift.api.TokenResponse;
import com.ghca.kms.thrift.api.VerifyWithHashedRequest;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.DataKeyPair;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsGm;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import org.apache.thrift.TException;

abstract class AbstractKmsClient
implements KmsClient {
    private static final int KEY_LEN = 16;
    private static final String TOKEN_KEY = "token";
    private static TimedCache<String, String> timedCache = CacheUtil.newTimedCache((long)360000L);
    private final KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();
    private static final String TRUE = "true";

    AbstractKmsClient() {
    }

    protected abstract KmsApi.Client getKmsApiClient() throws TException;

    protected abstract void returnKmsApiClient(KmsApi.Client var1) throws TException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKey generateCrtKey() throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKey dataKey;
            try {
                EncryptRequest request = new EncryptRequest();
                request.setAccessToken(token);
                request.setKeyId(this.kmsClientConfig.getCrtKeyId());
                request.setPlaintext(Base64.getEncoder().encodeToString(this.kmsClientConfig.getAccessKey().getBytes()));
                EncryptResponse response = client.encrypt(request);
                byte[] cipher = Base64.getDecoder().decode(response.getCiphertextBlob());
                byte[] cipherKey = new byte[16];
                System.arraycopy(cipher, 0, cipherKey, 0, cipherKey.length);
                dataKey = new DataKey(cipherKey, cipherKey, response.getKeyId());
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKey decryptOldDataKey(byte[] cipherKey, String cipherTxt, String cmkId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKey dataKey;
            try {
                DecryptRequest request = new DecryptRequest();
                request.setAccessToken(token);
                request.setKeyId(cmkId);
                request.setCiphertextBlob(cipherTxt);
                DecryptResponse response = client.decrypt(request);
                dataKey = new DataKey(cipherKey, cipherTxt, this.decryptKey(response.getPlaintext()), cmkId);
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKey;
        }
    }

    private byte[] decryptKey(String text) {
        String sk = this.kmsClientConfig.getSecretKey();
        byte[] encrypt2 = Base64.getDecoder().decode(text);
        return KmsGm.sm4Decrypt(sk.getBytes(), encrypt2);
    }

    private byte[] gcmDecryptKey(String text) {
        String sk = this.kmsClientConfig.getSecretKey();
        byte[] encrypt2 = Base64.getDecoder().decode(text);
        return KmsGm.sm4GCMDecrypt(sk.getBytes(), encrypt2);
    }

    @Override
    public DataKey generateDataKey() throws TException {
        return this.generateDataKey(this.kmsClientConfig.getCbcKeyId(), 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKey generateRandom(int length) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKey dataKey;
            try {
                DataKey dataKey2;
                GenerateRandomRequest request = new GenerateRandomRequest();
                request.setAccessToken(token);
                request.setByteLength(length);
                GenerateRandomResponse response = client.generateRandom(request);
                dataKey = dataKey2 = new DataKey(response.getRandom(), response.getRandom(), null);
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createKeyForSignVerify() throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                CreateKeyRequest request = new CreateKeyRequest();
                request.setAccessToken(token);
                request.setDescription("\u7b7e\u540d\u9a8c\u7b7e");
                request.setKeySpec(KeySpec.EC_SM2);
                request.setKeyUsage(KeyUsage.SIGN_VERIFY);
                request.setOrigin(Origin.KMS);
                request.setProtectionLevel(ProtectionLevel.HSM);
                request.setEnableAutomaticRotation(false);
                CreateKeyResponse response = client.createKey(request);
                string = response.getKeyMetadata().getKeyId();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPublicKey(String keyId, String keyVersionId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                GetPublicKeyRequest request = new GetPublicKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setKeyVersionId(keyVersionId);
                GetPublicKeyResponse response = client.getPublicKey(request);
                string = response.getPublicKey();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    @Override
    public DataKey generateDataKey(int length) throws TException {
        return this.generateDataKey(this.kmsClientConfig.getCbcKeyId(), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKey generateDataKey(String keyId, int length) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKey dataKey;
            try {
                GenerateDataKeyRequest request = new GenerateDataKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setKeySpec(KeySpec.SM4);
                request.setNumberOfBytes(length);
                GenerateDataKeyResponse response = client.generateDataKey(request);
                DataKey dataKey2 = new DataKey(Base64.getDecoder().decode(response.getCiphertextBlob()), this.decryptKey(response.getPlaintext()), response.getKeyId());
                dataKey2.setDataKeyId(response.getDataKeyId());
                dataKey = dataKey2;
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKey getDataKey(String dataKeyId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKey dataKey;
            try {
                GetDataKeyRequest request = new GetDataKeyRequest();
                request.setAccessToken(token);
                request.setDataKeyId(dataKeyId);
                GetDataKeyResponse response = client.getDataKey(request);
                String secretKey = this.kmsClientConfig.getSecretKey();
                byte[] keyBytes = Base64.getDecoder().decode(response.getKey());
                DataKey dataKey2 = new DataKey(keyBytes, KmsGm.sm4GCMDecrypt(secretKey.getBytes(), keyBytes), null);
                dataKey2.setDataKeyId(dataKeyId);
                dataKey = dataKey2;
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String describeKey(String keyId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                DescribeKeyRequest request = new DescribeKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                DescribeKeyResponse response = client.describeKey(request);
                string = response.getKeyMetadata().getArn();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() throws TException {
        String token = (String)timedCache.get((Object)TOKEN_KEY, false);
        if (token == null) {
            TimedCache<String, String> timedCache = AbstractKmsClient.timedCache;
            synchronized (timedCache) {
                token = (String)AbstractKmsClient.timedCache.get((Object)TOKEN_KEY, false);
                if (token == null) {
                    token = this.getTokenFromServer();
                    AbstractKmsClient.timedCache.put((Object)TOKEN_KEY, (Object)token);
                }
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTokenFromServer() throws TException {
        KmsApi.Client client;
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                ChallengeRequest challengeRequest = new ChallengeRequest();
                challengeRequest.setAccessKey(this.kmsClientConfig.getAccessKey());
                ChallengeResponse challengeResponse = client.getChallenge(challengeRequest);
                byte[] challengeCode = Base64.getDecoder().decode(challengeResponse.getChallengeCode());
                byte[] a = this.kmsClientConfig.getAccessKey().getBytes();
                byte[] total = new byte[challengeCode.length + a.length];
                System.arraycopy(challengeCode, 0, total, 0, challengeCode.length);
                System.arraycopy(a, 0, total, challengeCode.length, a.length);
                byte[] s = KmsGm.sm4Encrypt(this.kmsClientConfig.getSecretKey().getBytes(), total);
                ChallengeTokenRequest ctr = new ChallengeTokenRequest(this.kmsClientConfig.getAccessKey(), Base64.getEncoder().encodeToString(s));
                ChallengeTokenResponse ctrRes = client.getChallengeToken(ctr);
                string = ctrRes.getAccessToken();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTokenWithTimestamp() throws TException {
        KmsApi.Client client;
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                TokenRequest request = new TokenRequest();
                request.setAccesskey(this.kmsClientConfig.getAccessKey());
                String random = (UUID.randomUUID().toString() + UUID.randomUUID()).replace("-", "");
                request.setRandom(random);
                request.setDateTime(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now(ZoneOffset.UTC)));
                byte[] secretBytes = KmsGm.sm4EncryptPkcs7PaddingIv(this.kmsClientConfig.getSecretKey().getBytes(), (random + "-" + request.getDateTime()).getBytes());
                request.setSecretKey(Base64.getEncoder().encodeToString(secretBytes));
                TokenResponse response = client.getToken(request);
                string = response.getAccessToken();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateSm2Keypair(KeyUsage usage) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                CreateKeyRequest request = new CreateKeyRequest();
                request.setAccessToken(token);
                request.setKeySpec(KeySpec.EC_SM2);
                request.setKeyUsage(usage);
                request.setProtectionLevel(ProtectionLevel.SOFTWARE);
                request.setOrigin(Origin.KMS);
                CreateKeyResponse response = client.createKey(request);
                string = response.getKeyMetadata().getKeyId();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublicKey getSm2PublicKey(String keyId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            PublicKey publicKey;
            try {
                GetPublicKeyRequest request = new GetPublicKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                GetPublicKeyResponse response = client.getPublicKey(request);
                publicKey = KmsGm.getPublicKey(Base64.getDecoder().decode(response.getPublicKey()));
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return publicKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyKey(String keyId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            try {
                DeleteKeyRequest request = new DeleteKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                client.deleteKey(request);
            }
            finally {
                this.returnKmsApiClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String signWithPlain(String keyId, String keyVersionId, byte[] plain, Algorithm algorithm) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                AsymmetricSignRequest request = new AsymmetricSignRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setAlgorithm(algorithm);
                request.setDigest(Base64.getEncoder().encodeToString(plain));
                request.setKeyVersionId(keyVersionId);
                string = client.asymmetricSign(request).getValue();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyWithPlain(String keyId, String keyVersionId, byte[] plain, Algorithm algorithm, String sign) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            boolean bl;
            try {
                AsymmetricVerifyRequest request = new AsymmetricVerifyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setAlgorithm(algorithm);
                request.setDigest(Base64.getEncoder().encodeToString(plain));
                request.setValue(sign);
                request.setKeyVersionId(keyVersionId);
                bl = TRUE.equals(client.asymmetricVerify(request).getValue());
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String signWithDigest(String keyId, byte[] digest, DigestType type) throws TException {
        KmsApi.Client client;
        AbstractKmsClient.check(digest, type);
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                SignWithHashedRequest request = new SignWithHashedRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setDigest(Base64.getEncoder().encodeToString(digest));
                request.setDigestType(type);
                string = client.signWithHash(request).getValue();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyWithDigest(String keyId, byte[] digest, DigestType type, String sign) throws TException {
        KmsApi.Client client;
        AbstractKmsClient.check(digest, type);
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            boolean bl;
            try {
                VerifyWithHashedRequest request = new VerifyWithHashedRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setDigest(Base64.getEncoder().encodeToString(digest));
                request.setDigestType(type);
                request.setSign(sign);
                bl = TRUE.equals(client.verifyWithHash(request).getValue());
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encrypt(String keyId, String plainText) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                EncryptRequest request = new EncryptRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setPlaintext(plainText);
                EncryptResponse response = client.encrypt(request);
                string = response.getCiphertextBlob();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decrypt(String keyId, String ciphertextBlob, boolean useSkToDecryptData) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            try {
                byte[] plain;
                DecryptRequest request = new DecryptRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setCiphertextBlob(ciphertextBlob);
                DecryptResponse response = client.decrypt(request);
                byte[] cipher = Base64.getDecoder().decode(response.getPlaintext());
                if (!useSkToDecryptData) {
                    byte[] byArray = AbstractKmsClient.pkcs7cutting(cipher);
                    return byArray;
                }
                byte[] byArray = plain = KmsGm.sm4DecryptPkcs7PaddingIv(this.kmsClientConfig.getSecretKey().getBytes(), cipher);
                return byArray;
            }
            finally {
                this.returnKmsApiClient(client);
            }
        }
    }

    @Override
    public String encrypt(String plainText) throws TException {
        String keyId = this.kmsClientConfig.getCbcKeyId();
        return this.encrypt(keyId, plainText);
    }

    @Override
    public byte[] decrypt(String ciphertextBlob, boolean useSkToDecryptData) throws TException {
        String keyId = this.kmsClientConfig.getCbcKeyId();
        return this.decrypt(keyId, ciphertextBlob, useSkToDecryptData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataKeyPair generateKeyPair(KeySpec keySpec) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            DataKeyPair dataKeyPair;
            try {
                GenerateKeyPairRequest request = new GenerateKeyPairRequest();
                request.setAccessToken(token);
                GenerateKeyPairResponse response = client.generateKeyPair(request);
                dataKeyPair = new DataKeyPair(response.publicKey, response.plainPrivateKey);
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return dataKeyPair;
        }
    }

    @Override
    public String asymmetricEncrypt(String planeText) throws TException {
        return this.asymmetricEncrypt(this.kmsClientConfig.getAsymmetricKeyId(), planeText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asymmetricEncrypt(String keyId, String planeText) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                AsymmetricEncryptRequest asymmetricEncryptRequest = new AsymmetricEncryptRequest();
                asymmetricEncryptRequest.algorithm = Algorithm.SM2DSA;
                asymmetricEncryptRequest.setAccessToken(token);
                asymmetricEncryptRequest.setKeyId(keyId);
                asymmetricEncryptRequest.setPlaintext(planeText);
                AsymmetricEncryptResponse asymmetricEncryptResponse = client.asymmetricEncrypt(asymmetricEncryptRequest);
                string = asymmetricEncryptResponse.getCiphertextBlob();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asymmetricEncrypt(String keyId, String versionId, String planeText) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                AsymmetricEncryptRequest asymmetricEncryptRequest = new AsymmetricEncryptRequest();
                asymmetricEncryptRequest.algorithm = Algorithm.SM2DSA;
                asymmetricEncryptRequest.setAccessToken(token);
                asymmetricEncryptRequest.setKeyId(keyId);
                asymmetricEncryptRequest.setKeyVersionId(versionId);
                asymmetricEncryptRequest.setPlaintext(planeText);
                AsymmetricEncryptResponse asymmetricEncryptResponse = client.asymmetricEncrypt(asymmetricEncryptRequest);
                string = asymmetricEncryptResponse.getCiphertextBlob();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    @Override
    public String asymmetricDecrypt(String cipherText) throws TException {
        return this.asymmetricDecrypt(this.kmsClientConfig.getAsymmetricKeyId(), cipherText, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String asymmetricDecrypt(String keyId, String cipherText, boolean useSkToDecryptData) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            try {
                AsymmetricDecryptRequest asymmetricDecryptRequest = new AsymmetricDecryptRequest();
                asymmetricDecryptRequest.algorithm = Algorithm.SM2DSA;
                asymmetricDecryptRequest.setAccessToken(token);
                asymmetricDecryptRequest.setKeyId(keyId);
                asymmetricDecryptRequest.setCiphertextBlob(cipherText);
                AsymmetricDecryptResponse asymmetricDecryptResponse = client.asymmetricDecrypt(asymmetricDecryptRequest);
                if (useSkToDecryptData) {
                    String string = Base64.getEncoder().encodeToString(this.gcmDecryptKey(asymmetricDecryptResponse.getPlaintext()));
                    return string;
                }
                String string = asymmetricDecryptResponse.getPlaintext();
                return string;
            }
            finally {
                this.returnKmsApiClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asymmetricDecrypt(String keyId, String versionId, String cipherText) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                AsymmetricDecryptRequest asymmetricDecryptRequest = new AsymmetricDecryptRequest();
                asymmetricDecryptRequest.algorithm = Algorithm.SM2DSA;
                asymmetricDecryptRequest.setAccessToken(token);
                asymmetricDecryptRequest.setKeyId(keyId);
                asymmetricDecryptRequest.setKeyVersionId(versionId);
                asymmetricDecryptRequest.setCiphertextBlob(cipherText);
                AsymmetricDecryptResponse asymmetricDecryptResponse = client.asymmetricDecrypt(asymmetricDecryptRequest);
                string = asymmetricDecryptResponse.getPlaintext();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String symmetricEncryptByDataKey(String keyId, String dataId, String planeText, Mode mode, String cipherKey) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                EncryptByDataKeyRequest encryptByDataKeyRequest = new EncryptByDataKeyRequest();
                encryptByDataKeyRequest.setDataId(dataId);
                encryptByDataKeyRequest.setKeyId(keyId);
                encryptByDataKeyRequest.setPlainText(planeText);
                encryptByDataKeyRequest.setMode(mode);
                encryptByDataKeyRequest.setAccessToken(token);
                encryptByDataKeyRequest.setCipherKey(cipherKey);
                string = client.encryptByDataKey(encryptByDataKeyRequest).getCipherText();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String symmetricDecryptByDataKey(String dataId, String cipherText, Mode mode, String cipherKey) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            String string;
            try {
                DecryptByDataKeyRequest decryptByDataKeyRequest = new DecryptByDataKeyRequest();
                decryptByDataKeyRequest.setDataId(dataId);
                decryptByDataKeyRequest.setMode(mode);
                decryptByDataKeyRequest.setAccessToken(token);
                decryptByDataKeyRequest.setCipherText(cipherText);
                decryptByDataKeyRequest.setCipherKey(cipherKey);
                string = client.decryptByDataKey(decryptByDataKeyRequest).getPlainText();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hmac(String keyId, byte[] plain, DigestAlgorithm digestAlgorithm) throws TException {
        KmsApi.Client client;
        if (keyId == null) {
            keyId = this.kmsClientConfig.getCbcKeyId();
        }
        if (digestAlgorithm == null) {
            digestAlgorithm = DigestAlgorithm.SM3;
        }
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            byte[] byArray;
            try {
                HmacRequest request = new HmacRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setPlaintext(Base64.getEncoder().encodeToString(plain));
                request.setDigestAlgorithm(digestAlgorithm);
                HmacResponse response = client.hmac(request);
                byArray = response.getHmactextBlob();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hmacVerify(String keyId, byte[] plain, byte[] hmac2, DigestAlgorithm digestAlgorithm) throws TException {
        KmsApi.Client client;
        if (keyId == null) {
            keyId = this.kmsClientConfig.getCbcKeyId();
        }
        if (digestAlgorithm == null) {
            digestAlgorithm = DigestAlgorithm.SM3;
        }
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            boolean bl;
            try {
                HmacVerifyRequest request = new HmacVerifyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setPlaintext(Base64.getEncoder().encodeToString(plain));
                request.setHmactext(Base64.getEncoder().encodeToString(hmac2));
                request.setDigestAlgorithm(digestAlgorithm);
                HmacVerifyResponse response = client.hmacVerify(request);
                bl = response.isResult();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] exportSymmetricKey(String keyId) throws TException {
        KmsApi.Client client;
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            byte[] byArray;
            try {
                ExportSymmetricKeyRequest request = new ExportSymmetricKeyRequest();
                request.setAccessToken(token);
                request.setExportKeyId(keyId);
                request.setProtectionKeyId("");
                ExportSymmetricKeyResponse response = client.exportSymmetricKey(request);
                byArray = response.getExportKey();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping() throws TException {
        KmsApi.Client client;
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            try {
                PingRequest request = new PingRequest("ping");
                client.ping(request);
            }
            finally {
                this.returnKmsApiClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] deriveKey(String keyId, DeriveAlgorithm algorithm, int byteLength, byte[] salt) throws TException {
        KmsApi.Client client;
        if (keyId == null) {
            keyId = this.kmsClientConfig.getCbcKeyId();
        }
        String token = this.getToken();
        KmsApi.Client client2 = client = this.getKmsApiClient();
        synchronized (client2) {
            byte[] byArray;
            try {
                DeriveKeyRequest request = new DeriveKeyRequest();
                request.setAccessToken(token);
                request.setKeyId(keyId);
                request.setAlgorithm(algorithm);
                request.setByteLength(byteLength);
                request.setSalt(salt);
                DeriveKeyResponse response = client.deriveKey(request);
                byArray = response.getKey();
            }
            catch (Throwable throwable) {
                this.returnKmsApiClient(client);
                throw throwable;
            }
            this.returnKmsApiClient(client);
            return byArray;
        }
    }

    public static void check(byte[] data, DigestType type) {
        boolean flag;
        switch (type) {
            case SHA1: {
                flag = data.length == 20;
                break;
            }
            case SM3: 
            case SHA256: {
                flag = data.length == 32;
                break;
            }
            case SHA224: {
                flag = data.length == 28;
                break;
            }
            case SHA384: {
                flag = data.length == 48;
                break;
            }
            case SHA512: {
                flag = data.length == 64;
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u54c8\u5e0c\u7b97\u6cd5");
            }
        }
        if (!flag) {
            throw new RuntimeException("\u54c8\u5e0c\u503c\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
    }

    @Override
    public abstract KmsApi.Client getApiClient() throws TException;

    public static byte[] pkcs7cutting(byte[] input) {
        if (input == null) {
            return null;
        }
        byte p = input[input.length - 1];
        byte[] ret = new byte[input.length - p];
        System.arraycopy(input, 0, ret, 0, input.length - p);
        return ret;
    }

    static {
        timedCache.schedulePrune(200000L);
    }
}

