/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.Algorithm;
import com.ghca.kms.thrift.api.DeriveAlgorithm;
import com.ghca.kms.thrift.api.DigestAlgorithm;
import com.ghca.kms.thrift.api.DigestType;
import com.ghca.kms.thrift.api.KeyUsage;
import com.koal.kms.sdk.ed.ClientBuilder;
import com.koal.kms.sdk.ed.DataKey;
import com.koal.kms.sdk.ed.KmsCfb;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsCtr;
import com.koal.kms.sdk.ed.KmsFile;
import com.koal.kms.sdk.ed.KmsFpe;
import com.koal.kms.sdk.ed.KmsGcm;
import com.koal.kms.sdk.ed.KmsGm;
import com.koal.kms.sdk.ed.KmsSdkException;
import com.koal.kms.sdk.ed.Mode;
import com.koal.kms.sdk.ed.RandomSource;
import com.koal.kms.sdk.ed.actor.AbstractDecryptor;
import com.koal.kms.sdk.ed.actor.AbstractEncryptor;
import com.koal.kms.sdk.ed.actor.Sm4Decryptor;
import com.koal.kms.sdk.ed.actor.Sm4Encryptor;
import com.koal.kms.sdk.ed.util.EccCipherUtils;
import com.koal.kms.sdk.ed.vo.EccCipher;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import java.util.Random;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsUtil {
    private static final AbstractEncryptor DEFAULT_ENCRYPTOR;
    private static final AbstractDecryptor DEFAULT_DECRYPTOR;

    private KmsUtil() {
    }

    public static byte[] encrypt(byte[] plainData, Mode mode, byte[] iv) throws KmsSdkException {
        try {
            switch (mode) {
                case CBC: {
                    return KmsGm.encryptBySm4(plainData);
                }
                case CTR: {
                    if (!KmsClientConfig.isAllowUnsafeMode() && !KmsClientConfig.getInstance().isUnsafeMode()) {
                        throw new KmsSdkException("CTR\u4e3a\u975e\u5b89\u5168\u7684\u6a21\u5f0f,\u4e0d\u5141\u8bb8\u4f7f\u7528\u52a0\u5bc6");
                    }
                    return KmsCtr.encrypt(plainData, iv);
                }
                case CFB: {
                    return KmsCfb.encrypt(plainData, iv);
                }
                case GCM: {
                    return KmsGcm.encrypt(plainData);
                }
            }
            throw new KmsSdkException("\u76ee\u524d\u53ea\u652f\u6301CBC\u3001CTR\u3001CFB\u3001GCM\u52a0\u5bc6\u6a21\u5f0f");
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static byte[] encrypt(byte[] plainData, Mode mode) throws KmsSdkException {
        return KmsUtil.encrypt(plainData, mode, null);
    }

    public static byte[] convertCtrCipher2Cfb(byte[] cipherData, byte[] iv) {
        return KmsCfb.convertCtrCipher2Cfb(cipherData, iv);
    }

    public static byte[] convertCtrCipher2CtrWithIv(byte[] cipherData, byte[] iv) throws KmsSdkException {
        byte[] plain = KmsUtil.decrypt(cipherData, Mode.CTR, null);
        return KmsUtil.encrypt(plain, Mode.CTR, iv);
    }

    public static byte[] decrypt(byte[] cipherData, Mode mode, byte[] iv) throws KmsSdkException {
        try {
            switch (mode) {
                case CBC: {
                    return KmsGm.decryptBySm4(cipherData);
                }
                case CTR: {
                    return KmsCtr.decrypt(cipherData, iv);
                }
                case CFB: {
                    return KmsCfb.decrypt(cipherData, iv);
                }
                case GCM: {
                    return KmsGcm.decrypt(cipherData);
                }
            }
            throw new KmsSdkException("\u76ee\u524d\u53ea\u652f\u6301CBC\u3001CTR\u8fd92\u79cd\u52a0\u5bc6\u6a21\u5f0f");
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static byte[] decrypt(byte[] cipherData, Mode mode) throws KmsSdkException {
        return KmsUtil.decrypt(cipherData, mode, null);
    }

    public static byte[] sign(byte[] digest) throws KmsSdkException {
        try {
            return KmsGm.signBySm2(digest);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static boolean verifySign(byte[] digest, byte[] signed) throws KmsSdkException {
        try {
            return KmsGm.verifySignBySm2(digest, signed);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static byte[] hMac(byte[] plainData, DigestAlgorithm algorithm) throws KmsSdkException {
        if (algorithm != DigestAlgorithm.SM3) {
            throw new KmsSdkException("\u76ee\u524d\u53ea\u652f\u6301SM3\u7b97\u6cd5\u3002");
        }
        try {
            return KmsGm.hmacSM3Encrypt(plainData);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static boolean verifyHMac(byte[] plainData, byte[] hmacData, DigestAlgorithm algorithm) throws KmsSdkException {
        if (algorithm != DigestAlgorithm.SM3) {
            throw new KmsSdkException("\u76ee\u524d\u53ea\u652f\u6301SM3\u7b97\u6cd5\u3002");
        }
        try {
            return KmsGm.verifyHmacSm3(plainData, hmacData);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static byte[] hash(byte[] data, DigestAlgorithm algorithm) throws KmsSdkException {
        if (algorithm != DigestAlgorithm.SM3) {
            throw new KmsSdkException("\u76ee\u524d\u53ea\u652f\u6301SM3\u7b97\u6cd5\u3002");
        }
        try {
            return KmsUtil.sm3(data);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    private static byte[] sm3(byte[] data) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        byte[] result = new byte[sm3.getDigestSize()];
        sm3.doFinal(result, 0);
        return result;
    }

    public static byte[] hmacSm3(byte[] plainData) throws KmsSdkException {
        try {
            return KmsGm.hmacSM3Encrypt(plainData);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static boolean verifyHmacSm3(byte[] plainData, byte[] hmacData) throws KmsSdkException {
        try {
            return KmsGm.verifyHmacSm3(plainData, hmacData);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static String encryptWithFpe(String plain, Mode mode) throws KmsSdkException {
        try {
            if (mode == Mode.PASSWORD) {
                return KmsFpe.encrypt(plain);
            }
            if (mode == Mode.PHONE) {
                return KmsFpe.encryptPhone(plain);
            }
            throw new KmsSdkException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static String decryptWithFpe(String cipher, Mode mode) throws KmsSdkException {
        try {
            if (mode == Mode.PASSWORD) {
                return KmsFpe.decrypt(cipher);
            }
            if (mode == Mode.PHONE) {
                return KmsFpe.decryptPhone(cipher);
            }
            throw new KmsSdkException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static void encryptFile(String path, String encryptedName) throws KmsSdkException {
        try {
            KmsFile.encryptFile(path, encryptedName);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static void decryptFile(String path, String decryptedName) throws KmsSdkException {
        try {
            KmsFile.decryptFile(path, decryptedName);
        }
        catch (Exception e) {
            throw new KmsSdkException(e.getMessage(), e);
        }
    }

    public static String generateSm2ForSign() throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.generateSm2Keypair(KeyUsage.SIGN_VERIFY);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static PublicKey getSm2PublicKey(String keyId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.getSm2PublicKey(keyId);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static String sm2SignWithPlain(String keyId, String keyVersionId, byte[] data) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.signWithPlain(keyId, keyVersionId, data, Algorithm.SM2DSA);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static boolean sm2VerifyWithPlain(String keyId, String keyVersionId, byte[] data, String sign) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.verifyWithPlain(keyId, keyVersionId, data, Algorithm.SM2DSA, sign);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static String sm2SignWithDigest(String keyId, byte[] digest) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.signWithDigest(keyId, digest, DigestType.SM3);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static String createKeyForSignVerify() throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.createKeyForSignVerify();
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static String getPublicKey(String keyId, String keyVersionId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.getPublicKey(keyId, keyVersionId);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static boolean sm2VerifyWithDigest(String keyId, byte[] digest, String sign) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.verifyWithDigest(keyId, digest, DigestType.SM3, sign);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static void destroyKey(String keyId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            client.destroyKey(keyId);
        }
        catch (Exception e) {
            throw new KmsSdkException(e);
        }
    }

    public static DataKey generateSymmKey(int length) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.generateDataKey(length);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static DataKey generateDataKey(int length) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.generateRandom(length);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] generateRandom(int length, RandomSource randomSource) throws KmsSdkException {
        switch (randomSource) {
            case KMS: {
                try {
                    KmsClient client = ClientBuilder.getInstance();
                    return client.generateRandom(length).getPlainKey();
                }
                catch (Exception e) {
                    throw new KmsSdkException("Communicate with kms server error:", e);
                }
            }
            case LOCAL_RANDOM: {
                byte[] bytes = new byte[length];
                Random random = new Random();
                random.nextBytes(bytes);
                return bytes;
            }
            case LOCAL_SECURE_RANDOM: {
                byte[] secureBytes = new byte[length];
                SecureRandom secureRandom = new SecureRandom();
                ((Random)secureRandom).nextBytes(secureBytes);
                return secureBytes;
            }
        }
        throw new KmsSdkException("\u4e0d\u652f\u6301\u7684\u968f\u673a\u6e90\uff1a" + randomSource.name());
    }

    public static byte[] generateRandom(int length) throws KmsSdkException {
        return KmsUtil.generateRandom(length, RandomSource.KMS);
    }

    public static DataKey getDataKey(String dataKeyId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.getDataKey(dataKeyId);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] symmEncrypt(byte[] key, byte[] iv, byte[] plain) throws KmsSdkException {
        try {
            return DEFAULT_ENCRYPTOR.encrypt(key, iv, plain);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] symmDecrypt(byte[] key, byte[] iv, byte[] cipher) throws KmsSdkException {
        try {
            return DEFAULT_DECRYPTOR.decrypt(key, iv, cipher);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] encrypt(String keyId, byte[] plain) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.encrypt(keyId, Base64.getEncoder().encodeToString(KmsUtil.pkcs7Padding(plain))));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] decrypt(String keyId, byte[] cipher) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.decrypt(keyId, Base64.getEncoder().encodeToString(cipher), true);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] encrypt(byte[] plain) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.encrypt(Base64.getEncoder().encodeToString(KmsUtil.pkcs7Padding(plain))));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] decrypt(byte[] cipher) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.decrypt(Base64.getEncoder().encodeToString(cipher), true);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] decryptNoSK(byte[] cipher) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.decrypt(Base64.getEncoder().encodeToString(cipher), false);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static KeyPair generateAsymmKeyPair(int keyLen) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("EC", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
        kpg.initialize(keyLen);
        return kpg.generateKeyPair();
    }

    public static byte[] asymmEncrypt(String keyId, byte[] plain) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.asymmetricEncrypt(keyId, Base64.getEncoder().encodeToString(plain)));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] asymmEncrypt(String keyId, String versionId, byte[] plain) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.asymmetricEncrypt(keyId, versionId, Base64.getEncoder().encodeToString(plain)));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] asymmDecrypt(String keyId, byte[] cipher) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.asymmetricDecrypt(keyId, Base64.getEncoder().encodeToString(cipher), true));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] asymmDecrypt(String keyId, String versionId, byte[] cipher) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return Base64.getDecoder().decode(client.asymmetricDecrypt(keyId, versionId, Base64.getEncoder().encodeToString(cipher)));
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] asymmEncrypt(PublicKey publicKey, byte[] plain) {
        try {
            BCECPublicKey _publicKey = (BCECPublicKey)publicKey;
            AsymmetricKeyParameter ecPublicKeyParameters = PublicKeyFactory.createKey((byte[])_publicKey.getEncoded());
            SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)ecPublicKeyParameters, new SecureRandom()));
            return sm2Engine.processBlock(plain, 0, plain.length);
        }
        catch (IOException | InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] asymmDecrypt(PrivateKey privateKey, byte[] cipher) {
        try {
            BCECPrivateKey _privateKey = (BCECPrivateKey)privateKey;
            AsymmetricKeyParameter ecPrivateKeyParameters = PrivateKeyFactory.createKey((byte[])_privateKey.getEncoded());
            SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
            sm2Engine.init(false, (CipherParameters)ecPrivateKeyParameters);
            return sm2Engine.processBlock(cipher, 0, cipher.length);
        }
        catch (IOException | InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static EccCipher exportSymmetricKey(String keyId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            byte[] symmetricKey = client.exportSymmetricKey(keyId);
            return EccCipherUtils.convertIntoEccCipher(symmetricKey);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static void ping() throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            client.ping();
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] pkcs7Padding(byte[] input) {
        if (input == null) {
            return null;
        }
        int p = 16 - input.length % 16;
        byte[] ret = new byte[input.length + p];
        System.arraycopy(input, 0, ret, 0, input.length);
        for (int i = 0; i < p; ++i) {
            ret[input.length + i] = (byte)p;
        }
        return ret;
    }

    public static byte[] hmacOnKms(String keyId, byte[] plain, DigestAlgorithm digestAlgorithm) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.hmac(keyId, plain, digestAlgorithm);
        }
        catch (Exception e) {
            throw new KmsSdkException("hmac:", e);
        }
    }

    public static boolean hmacVerifyOnKms(String keyId, byte[] plain, byte[] hmac2, DigestAlgorithm digestAlgorithm) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.hmacVerify(keyId, plain, hmac2, digestAlgorithm);
        }
        catch (Exception e) {
            throw new KmsSdkException("hmacVerify:", e);
        }
    }

    public static String describeKey(String keyId) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            return client.describeKey(keyId);
        }
        catch (Exception e) {
            throw new KmsSdkException("Communicate with kms server error:", e);
        }
    }

    public static byte[] deriveKey(String keyId, DeriveAlgorithm algorithm, int byteLength, byte[] salt) throws KmsSdkException {
        try {
            KmsClient client = ClientBuilder.getInstance();
            if (algorithm == null) {
                algorithm = DeriveAlgorithm.SHA256;
            }
            return client.deriveKey(keyId, algorithm, byteLength, salt);
        }
        catch (Exception e) {
            throw new KmsSdkException("deriveKey fail:", e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DEFAULT_ENCRYPTOR = new Sm4Encryptor();
        DEFAULT_DECRYPTOR = new Sm4Decryptor();
    }
}

