/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSocketDirect;
import kl.ssl.jsse.provider.SSLParametersUtil;
import kl.ssl.jsse.provider.SSLSocketUtil;

class ProvSSLServerSocket
extends SSLServerSocket {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port) throws IOException {
        super(port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port, int backlog) throws IOException {
        super(port, backlog);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    @Override
    public synchronized Socket accept() throws IOException {
        ProvSSLSocketDirect socket = SSLSocketUtil.create(this.context, this.contextData, this.enableSessionCreation, this.useClientMode, this.sslParameters.copy());
        this.implAccept(socket);
        socket.notifyConnected();
        return socket;
    }

    @Override
    public ServerSocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.useClientMode != useClientMode) {
            this.context.updateDefaultProtocols(this.sslParameters, !useClientMode);
            this.useClientMode = useClientMode;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }
}

