/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum DigestAlgorithm implements TEnum
{
    SHA1(1),
    SHA256(2),
    SHA512(3),
    SHA384(4),
    SHA224(5),
    NO_PREHASH(6),
    SM3(7);

    private final int value;

    private DigestAlgorithm(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static DigestAlgorithm findByValue(int value) {
        switch (value) {
            case 1: {
                return SHA1;
            }
            case 2: {
                return SHA256;
            }
            case 3: {
                return SHA512;
            }
            case 4: {
                return SHA384;
            }
            case 5: {
                return SHA224;
            }
            case 6: {
                return NO_PREHASH;
            }
            case 7: {
                return SM3;
            }
        }
        return null;
    }
}

