/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.failover;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.koal.kms.sdk.ed.thrift.constants.ServiceLevel;
import com.koal.kms.sdk.ed.thrift.failover.ConnectionValidator;
import com.koal.kms.sdk.ed.thrift.failover.FailoverStrategy;
import com.koal.kms.sdk.ed.thrift.pool.ThriftConnectionPool;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChecker {
    private final Logger logger = LoggerFactory.getLogger(FailoverChecker.class);
    private List<ThriftServer> serverList;
    private List<ThriftServer> backupServerList;
    private ThriftConnectionPool poolProvider;
    private ScheduledExecutorService checkExecutor;
    private final FailoverStrategy<ThriftServer> failoverStrategy;
    private final ConnectionValidator connectionValidator;
    private final ServiceLevel serviceLevel;

    public FailoverChecker(ConnectionValidator connectionValidator, FailoverStrategy<ThriftServer> failoverStrategy, ServiceLevel serviceLevel) {
        this.connectionValidator = connectionValidator;
        this.failoverStrategy = failoverStrategy;
        this.serviceLevel = serviceLevel;
    }

    public void setConnectionPool(ThriftConnectionPool poolProvider) {
        this.poolProvider = poolProvider;
    }

    public void startChecking() {
        if (this.connectionValidator != null) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Fail Check Worker").build();
            this.checkExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.checkExecutor.scheduleAtFixedRate(new Checker(), 1L, 1L, TimeUnit.MINUTES);
        }
    }

    public void setServerList(List<ThriftServer> serverList) {
        this.serverList = serverList;
    }

    public void setBackupServerList(List<ThriftServer> backupServerList) {
        this.backupServerList = backupServerList;
    }

    public List<ThriftServer> getAvailableServers() {
        return this.getAvailableServers(false);
    }

    private List<ThriftServer> getAvailableServers(boolean all) {
        ArrayList<ThriftServer> returnList = new ArrayList<ThriftServer>();
        Set<ThriftServer> failedServers = this.failoverStrategy.getFailed();
        for (ThriftServer thriftServer : this.serverList) {
            if (failedServers.contains(thriftServer)) continue;
            returnList.add(thriftServer);
        }
        if (this.serviceLevel == ServiceLevel.SERVERS_ONLY) {
            return returnList;
        }
        if ((all || returnList.isEmpty()) && !this.backupServerList.isEmpty()) {
            for (ThriftServer thriftServer : this.backupServerList) {
                if (failedServers.contains(thriftServer)) continue;
                returnList.add(thriftServer);
            }
        }
        if (this.serviceLevel == ServiceLevel.ALL_SERVERS) {
            return returnList;
        }
        if (returnList.isEmpty()) {
            returnList.addAll(this.serverList);
        }
        return returnList;
    }

    public FailoverStrategy<ThriftServer> getFailoverStrategy() {
        return this.failoverStrategy;
    }

    public ConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    public void stopChecking() {
        if (this.checkExecutor != null) {
            this.checkExecutor.shutdown();
        }
    }

    private class Checker
    implements Runnable {
        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (ThriftServer thriftServer : FailoverChecker.this.getAvailableServers(true)) {
                TTransport tt = null;
                boolean valid = false;
                try {
                    tt = FailoverChecker.this.poolProvider.getConnection(thriftServer);
                    valid = FailoverChecker.this.connectionValidator.isValid(tt);
                }
                catch (Exception e) {
                    FailoverChecker.this.logger.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (tt != null) {
                        if (valid) {
                            FailoverChecker.this.poolProvider.returnConnection(thriftServer, tt);
                            continue;
                        }
                        FailoverChecker.this.failoverStrategy.fail(thriftServer);
                        FailoverChecker.this.poolProvider.returnBrokenConnection(thriftServer, tt);
                        continue;
                    }
                    FailoverChecker.this.failoverStrategy.fail(thriftServer);
                }
            }
        }
    }
}

