/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum DeriveAlgorithm implements TEnum
{
    AES_CMAC(8384),
    TRI_DES_CMAC(4288),
    SHA1(2),
    SHA224(32),
    SHA256(4),
    SHA384(16),
    SHA512(8);

    private final int value;

    private DeriveAlgorithm(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static DeriveAlgorithm findByValue(int value) {
        switch (value) {
            case 8384: {
                return AES_CMAC;
            }
            case 4288: {
                return TRI_DES_CMAC;
            }
            case 2: {
                return SHA1;
            }
            case 32: {
                return SHA224;
            }
            case 4: {
                return SHA256;
            }
            case 16: {
                return SHA384;
            }
            case 8: {
                return SHA512;
            }
        }
        return null;
    }
}

