/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.koal.kms.config.ConfigUtil;
import com.koal.kms.sdk.ed.KmsClientConfigInitializer;
import com.koal.kms.sdk.ed.thrift.constants.LoadBalance;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;

public class KmsClientConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(KmsClientConfig.class);
    private static final String KMS_CLIENT_YML = "kms_client.yml";
    private static final LoaderOptions loaderOptions = new LoaderOptions();
    private static KmsClientConfig instance;
    private static boolean allowUnsafeMode;
    private String address;
    private String accessKey;
    private String secretKey;
    private String kid;
    private String contextPath;
    private String cbcKeyId;
    private String crtKeyId;
    private String asymmetricKeyId;
    private boolean useTLS;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyPassword;
    private String trustStorePath;
    private String trustStorePassword;
    private int retryCount = 2;
    private long logTimeout = 1000L;
    private boolean unsafeMode = false;
    private boolean useRsa = false;
    private Boolean local = true;
    private int loadBalance = LoadBalance.ROUND_ROBIN.getValue();
    private static KmsClientConfigInitializer initializer;
    private Pooling pooling = new Pooling();

    public boolean isUnsafeMode() {
        return this.unsafeMode;
    }

    public void setUnsafeMode(boolean unsafeMode) {
        this.unsafeMode = unsafeMode;
    }

    public KmsClientConfigInitializer getInitializer() {
        return initializer;
    }

    public static void enableUnsafeMode() {
        allowUnsafeMode = true;
    }

    public static void disableUnsafeMode() {
        allowUnsafeMode = false;
    }

    static boolean isAllowUnsafeMode() {
        return allowUnsafeMode;
    }

    public boolean getUseTLS() {
        return this.useTLS;
    }

    public boolean getUseRsa() {
        return this.useRsa;
    }

    public Pooling getPooling() {
        return this.pooling;
    }

    public void setPooling(Pooling pooling) {
        this.pooling = pooling;
    }

    public boolean useRsa() {
        return this.useRsa;
    }

    public void setUseRsa(boolean useRsa) {
        this.useRsa = useRsa;
    }

    public Boolean getLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public int getLoadBalance() {
        return this.loadBalance;
    }

    public void setLoadBalance(int loadBalance) {
        this.loadBalance = loadBalance;
    }

    public static KmsClientConfig init(KmsClientConfig config) {
        if (instance != null) {
            return instance;
        }
        instance = config;
        return instance;
    }

    public static KmsClientConfig getInstance() {
        if (null != instance) {
            return instance;
        }
        if (KmsClientConfigInitializer.isInitialized()) {
            LOGGER.info("\u8c03\u7528KmsClientConfigInitializer#init\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e\u53c2\u6570");
            initializer = KmsClientConfigInitializer.getInstance();
            instance = (KmsClientConfig)new Yaml(loaderOptions).loadAs((InputStream)new ByteArrayInputStream(initializer.getConfigProperties()), KmsClientConfig.class);
        } else {
            LOGGER.info("\u8bfb\u53d6\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u914d\u7f6e\u53c2\u6570");
            try (InputStream inputStream = KmsClientConfig.getKmsClientInputStream();){
                byte[] result = ConfigUtil.decryptInputStream(inputStream);
                instance = (KmsClientConfig)new Yaml(loaderOptions).loadAs((InputStream)new ByteArrayInputStream(result), KmsClientConfig.class);
            }
            catch (Exception e) {
                LOGGER.info("\u8bfb\u53d6\u660e\u6587\u914d\u7f6e");
                instance = (KmsClientConfig)new Yaml(loaderOptions).loadAs(KmsClientConfig.getKmsClientInputStream(), KmsClientConfig.class);
            }
        }
        LOGGER.info("address=" + instance.getAddress() + ",ak/sk=" + instance.getAccessKey() + "/" + instance.getSecretKey());
        return instance;
    }

    private static InputStream getKmsClientInputStream() {
        try {
            InputStream inputStream = new FileInputStream(System.getProperty("user.dir") + File.separator + KMS_CLIENT_YML);
            if (inputStream == null) {
                inputStream = KmsClientConfig.class.getClassLoader().getResourceAsStream(KMS_CLIENT_YML);
            }
            return inputStream;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getCbcKeyId() {
        if (null == this.cbcKeyId || this.cbcKeyId.length() == 0) {
            return "alias" + this.accessKey + "1";
        }
        return this.cbcKeyId;
    }

    public String getAsymmetricKeyId() {
        return this.asymmetricKeyId;
    }

    public void setAsymmetricKeyId(String asymmetricKeyId) {
        this.asymmetricKeyId = asymmetricKeyId;
    }

    public void setCbcKeyId(String cbcKeyId) {
        this.cbcKeyId = cbcKeyId;
    }

    public String getKcspKid() {
        return this.kid;
    }

    public String getCrtKeyId() {
        if (null == this.crtKeyId || this.crtKeyId.length() == 0) {
            return "alias" + this.accessKey + "2";
        }
        return this.crtKeyId;
    }

    public void setCrtKeyId(String crtKeyId) {
        this.crtKeyId = crtKeyId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public boolean useTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getLogTimeout() {
        return this.logTimeout;
    }

    public void setLogTimeout(long logTimeout) {
        this.logTimeout = logTimeout;
    }

    static {
        allowUnsafeMode = false;
    }

    public static class Pooling {
        int maxTotal = 8;
        int minIdle = 1;
        boolean testWhileIdle = true;
        boolean testOnBorrow = false;
        boolean testOnReturn = false;
        int validatePeriod = 300000;
        int testConnTime = 2000;
        int failCount = 1;
        long failDuration = 1L;
        long recoverDuration = 5L;

        public int getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(int maxTotal) {
            if (maxTotal <= 1) {
                throw new IllegalArgumentException("maxTotal should greater than 1");
            }
            this.maxTotal = maxTotal;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(int minIdle) {
            if (minIdle <= 1) {
                throw new IllegalArgumentException("maxTotal should greater than 1");
            }
            this.minIdle = minIdle;
        }

        public boolean getTestWhileIdle() {
            return this.testWhileIdle;
        }

        public void setTestWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
        }

        public boolean getTestOnBorrow() {
            return this.testOnBorrow;
        }

        public void setTestOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
        }

        public boolean getTestOnReturn() {
            return this.testOnReturn;
        }

        public void setTestOnReturn(boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
        }

        public int getValidatePeriod() {
            return this.validatePeriod;
        }

        public int getTestConnTime() {
            return this.testConnTime;
        }

        public void setTestConnTime(int testConnTime) {
            this.testConnTime = testConnTime;
        }

        public int getFailCount() {
            return this.failCount;
        }

        public void setFailCount(int failCount) {
            this.failCount = failCount;
        }

        public long getFailDuration() {
            return this.failDuration;
        }

        public void setFailDuration(long failDuration) {
            this.failDuration = failDuration;
        }

        public long getRecoverDuration() {
            return this.recoverDuration;
        }

        public void setRecoverDuration(long recoverDuration) {
            this.recoverDuration = recoverDuration;
        }

        public void setValidatePeriod(int validatePeriod) {
            if (validatePeriod <= 1) {
                throw new IllegalArgumentException("validatePeriod should greater than 1ms");
            }
            this.validatePeriod = validatePeriod;
        }
    }
}

