/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsCryptoProvider;
import kl.ssl.jsse.BCX509ExtendedTrustManager;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.DummyX509KeyManager;
import kl.ssl.jsse.provider.DummyX509TrustManager;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.KeyStoreConfig;
import kl.ssl.jsse.provider.PropertyUtils;
import kl.ssl.jsse.provider.ProvKeyManagerFactorySpi;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLServerSocketFactory;
import kl.ssl.jsse.provider.ProvSSLSessionContext;
import kl.ssl.jsse.provider.ProvSSLSocketFactory;
import kl.ssl.jsse.provider.ProvTrustManagerFactorySpi;
import kl.ssl.jsse.provider.SSLEngineUtil;
import kl.ssl.jsse.provider.X509KeyManagerUtil;
import kl.ssl.jsse.provider.X509TrustManagerUtil;

class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(ProvSSLContextSpi.class.getName());
    private static final String PROPERTY_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String PROPERTY_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    private static final Map<String, Integer> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, ProtocolVersion> supportedProtocols = ProvSSLContextSpi.createSupportedProtocols();
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"GMVPNv1.1"};
    protected final TlsCryptoProvider cryptoProvider;
    protected final String[] defaultProtocolsClient;
    protected final String[] defaultProtocolsServer;
    protected final Map<String, Integer> supportedCipherSuites;
    protected final String[] defaultCipherSuites;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509ExtendedKeyManager x509KeyManager;
    private BCX509ExtendedTrustManager x509TrustManager;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static List<String> createDefaultCipherSuiteList(Set<String> supportedCipherSuiteSet) {
        ArrayList<String> cs = new ArrayList<String>();
        cs.add("GMVPN_SM2_WITH_SM4_CBC_SM3");
        cs.add("GMVPN_SM2_WITH_SM4_GCM_SM3");
        cs.add("GMVPN_RSA_WITH_SM4_CBC_SM3");
        cs.add("GMVPN_RSA_WITH_SM4_CBC_SHA");
        cs.retainAll(supportedCipherSuiteSet);
        cs.trimToSize();
        return Collections.unmodifiableList(cs);
    }

    private static Map<String, Integer> createSupportedCipherSuiteMap() {
        HashMap<String, Integer> cs = new HashMap<String, Integer>(){

            @Override
            public Integer put(String key, Integer value) {
                if (null != super.put(key, value)) {
                    throw new IllegalStateException("Duplicate names in supported-cipher-suites");
                }
                return null;
            }
        };
        cs.put("GMVPN_SM2_WITH_SM4_CBC_SM3", 57363);
        cs.put("GMVPN_SM2_WITH_SM4_GCM_SM3", 57427);
        cs.put("GMVPN_RSA_WITH_SM4_CBC_SM3", 57369);
        cs.put("GMVPN_RSA_WITH_SM4_CBC_SHA", 57370);
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocols() {
        HashMap<String, ProtocolVersion> ps = new HashMap<String, ProtocolVersion>();
        ps.put("GMVPNv1.1", ProtocolVersion.GMVPNv11);
        return Collections.unmodifiableMap(ps);
    }

    private static String[] getDefaultProtocols(String[] specifiedProtocols, String propertyName) {
        if (specifiedProtocols != null) {
            return specifiedProtocols;
        }
        String[] propertyProtocols = ProvSSLContextSpi.getJdkTlsProtocols(propertyName);
        if (propertyProtocols != null) {
            return propertyProtocols;
        }
        return DEFAULT_PROTOCOLS;
    }

    private static String[] getDefaultProtocolsClient(String[] specifiedProtocols) {
        return ProvSSLContextSpi.getDefaultProtocols(specifiedProtocols, PROPERTY_CLIENT_PROTOCOLS);
    }

    private static String[] getDefaultProtocolsServer(String[] specifiedProtocols) {
        return ProvSSLContextSpi.getDefaultProtocols(specifiedProtocols, PROPERTY_SERVER_PROTOCOLS);
    }

    private static String[] getJdkTlsProtocols(String propertyName) {
        String prop = PropertyUtils.getStringSystemProperty(propertyName);
        if (prop == null) {
            return null;
        }
        String[] entries = JsseUtils.stripDoubleQuotes(prop.trim()).split(",");
        String[] result = new String[entries.length];
        int count = 0;
        for (String entry : entries) {
            String protocol = entry.trim();
            if (protocol.length() < 1) continue;
            if (!supportedProtocols.containsKey(protocol)) {
                LOG.warning("'" + propertyName + "' contains unsupported protocol: " + protocol);
                continue;
            }
            if (JsseUtils.contains(result, protocol)) continue;
            result[count++] = protocol;
        }
        if (count < 1) {
            LOG.severe("'" + propertyName + "' contained no usable protocol values (ignoring)");
            return null;
        }
        if (count < result.length) {
            result = JsseUtils.copyOf(result, count);
        }
        return result;
    }

    private static String[] getArray(Collection<String> c) {
        return c.toArray(new String[c.size()]);
    }

    private static String[] getKeysArray(Map<String, ?> m) {
        return ProvSSLContextSpi.getArray(m.keySet());
    }

    static KeyManager[] getDefaultKeyManagers() throws Exception {
        KeyStoreConfig keyStoreConfig = ProvKeyManagerFactorySpi.getDefaultKeyStore();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStoreConfig.keyStore, keyStoreConfig.password);
        return kmf.getKeyManagers();
    }

    static TrustManager[] getDefaultTrustManagers() throws Exception {
        KeyStore trustStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        return tmf.getTrustManagers();
    }

    ProvSSLContextSpi(TlsCryptoProvider cryptoProvider, String[] specifiedProtocols) {
        this.cryptoProvider = cryptoProvider;
        this.defaultProtocolsClient = ProvSSLContextSpi.getDefaultProtocolsClient(specifiedProtocols);
        this.defaultProtocolsServer = ProvSSLContextSpi.getDefaultProtocolsServer(specifiedProtocols);
        this.supportedCipherSuites = SUPPORTED_CIPHERSUITE_MAP;
        List<String> defaultCipherSuiteList = DEFAULT_CIPHERSUITE_LIST;
        this.defaultCipherSuites = ProvSSLContextSpi.getArray(defaultCipherSuiteList);
    }

    int[] convertCipherSuites(String[] suites) {
        int[] result = new int[suites.length];
        for (int i = 0; i < suites.length; ++i) {
            result[i] = this.supportedCipherSuites.get(suites[i]);
        }
        return result;
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this, this.crypto);
    }

    String getCipherSuiteString(int suite) {
        if (0 == suite) {
            return "TLS_NULL_WITH_NULL_NULL";
        }
        if (TlsUtils.isValidUint16(suite)) {
            for (Map.Entry<String, Integer> entry : this.supportedCipherSuites.entrySet()) {
                if (entry.getValue() != suite) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getDefaultCipherSuites() {
        return (String[])this.defaultCipherSuites.clone();
    }

    ProvSSLParameters getDefaultParameters(boolean isServer) {
        return new ProvSSLParameters(this, this.defaultCipherSuites, this.getDefaultProtocols(isServer));
    }

    String[] getDefaultProtocols(boolean isServer) {
        return isServer ? this.getDefaultProtocolsServer() : this.getDefaultProtocolsClient();
    }

    String[] getDefaultProtocolsClient() {
        return this.defaultProtocolsClient;
    }

    String[] getDefaultProtocolsServer() {
        return this.defaultProtocolsServer;
    }

    String getProtocolString(ProtocolVersion v) {
        if (v != null) {
            for (Map.Entry<String, ProtocolVersion> entry : supportedProtocols.entrySet()) {
                if (!v.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    ProtocolVersion[] getSupportedVersions(String[] protocols) {
        if (protocols == null) {
            return null;
        }
        TreeSet<ProtocolVersion> versions = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion o1, ProtocolVersion o2) {
                return o1.isLaterVersionOf(o2) ? -1 : (o2.isLaterVersionOf(o1) ? 1 : 0);
            }
        });
        for (String protocol : protocols) {
            ProtocolVersion version;
            if (protocol == null || (version = supportedProtocols.get(protocol)) == null) continue;
            versions.add(version);
        }
        return versions.toArray(new ProtocolVersion[versions.size()]);
    }

    boolean isDefaultProtocols(String[] protocols) {
        return protocols == this.getDefaultProtocolsClient() || protocols == this.getDefaultProtocolsServer();
    }

    String[] getSupportedCipherSuites() {
        return ProvSSLContextSpi.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedProtocols() {
        return ProvSSLContextSpi.getKeysArray(supportedProtocols);
    }

    String[] getSupportedCipherSuites(String[] cipherSuites) {
        if (null == cipherSuites) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>(cipherSuites.length);
        for (String cipherSuite : cipherSuites) {
            if (null == cipherSuite || cipherSuite.length() < 1) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(cipherSuite)) continue;
            result.add(cipherSuite);
        }
        return ProvSSLContextSpi.getArray(result);
    }

    boolean isSupportedProtocols(String[] protocols) {
        if (protocols == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (protocol != null && supportedProtocols.containsKey(protocol)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultProtocols(ProvSSLParameters sslParameters, boolean isServer) {
        if (this.isDefaultProtocols(sslParameters.getProtocolsArray())) {
            sslParameters.setProtocolsArray(this.getDefaultProtocols(isServer));
        }
    }

    void validateNegotiatedCipherSuite(int cipherSuite) {
        String cs = this.getCipherSuiteString(cipherSuite);
        if (cs == null || !this.supportedCipherSuites.containsKey(cs)) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + cipherSuite);
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String host, int port) {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData(), host, port);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(this.getSupportedCipherSuites());
        r.setProtocols(this.getSupportedProtocols());
        return r;
    }

    @Override
    protected synchronized void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(sr);
        this.x509KeyManager = this.selectX509KeyManager(kms);
        this.x509TrustManager = this.selectX509TrustManager(tms);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.crypto.getSecureRandom().nextInt();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.x509KeyManager, this.x509TrustManager, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509ExtendedKeyManager selectX509KeyManager(KeyManager[] kms) throws KeyManagementException {
        if (kms != null) {
            for (KeyManager km : kms) {
                if (!(km instanceof X509KeyManager)) continue;
                return X509KeyManagerUtil.importX509KeyManager((X509KeyManager)km);
            }
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected BCX509ExtendedTrustManager selectX509TrustManager(TrustManager[] tms) throws KeyManagementException {
        if (tms == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tms = tmf.getTrustManagers();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", e);
            }
        }
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                return X509TrustManagerUtil.importX509TrustManager((X509TrustManager)tm);
            }
        }
        return DummyX509TrustManager.INSTANCE;
    }
}

